<?php
/***************************************************************************
 Filename:      includes/lang/japanese.inc.php
 Function:      Japanese language file for Etomite (UTF-8).
 Modified By:   The Etomite Content Management System Project
 Author:        Mitsuhiro Yoshida - http://mitstek.com/
 Last Modified: 2008-05-01 [Prelude v1.0]
/***************************************************************************/

$_lang["login_message"] = "Etomiteセッションを開始するため、あなたのログイン情報を入力してください。ユーザ名とパスワードは大文字小文字を区別します。慎重に入力してください!"; // changed 06 RC2
$_lang["login_terms_error"] = "申し訳ございません! ログインするには、利用規約に同意してください。";
$_lang["include_ordering_error"] = "<b>INCLUDE_ORDERING_ERROR</b><br /><br />このファイルに直接アクセスするのではなく、Etomiteマネージャを使用してください。";
$_lang["username"] = "ユーザ名";
$_lang["password"] = "パスワード";
$_lang["remember_username"] = "ログイン情報を記憶する";
$_lang["login_button"] = "ログイン";
$_lang["home"] = "Home";
$_lang["my_etomite"] = "My Etomite";
$_lang["my_preferences"] = "詳細設定";
$_lang["site"] = "サイト";
$_lang["launch_site"] = "サイトの表示";
$_lang["refresh_site"] = "サイトキャッシュのクリア";
$_lang["content"] = "コンテンツ";
$_lang["add_document"] = "ドキュメントの作成";
$_lang["add_weblink"] = "ウェブリンクの作成";
$_lang["site_schedule"] = "サイトスケジュール";
$_lang["search"] = "検索";
$_lang["visitor_stats"] = "ビジターステータス";
$_lang["messages"] = "メッセージ";
$_lang["users"] = "ユーザ";
$_lang["change_password"] = "パスワードの変更";
$_lang["new_user"] = "ユーザの作成";
$_lang["edit_user"] = "ユーザの編集";
$_lang["new_role"] = "ロールの作成";
$_lang["edit_role"] = "ロールの編集";
$_lang["access_permissions"] = "パーミッション";
$_lang["administration"] = "管理";
$_lang["edit_settings"] = "Etomite設定";
$_lang["view_sysinfo"] = "システム情報";
$_lang["edit_parser"] = "パーサの編集";
$_lang["site_parser"] = "サイトパーサ";
$_lang["action_parser"] = "アクションパーサ";
$_lang["view_logging"] = "ログ";
$_lang["manage_files"] = "ファイル管理";
$_lang["remove_locks"] = "ロックファイルの削除";
$_lang["resources"] = "リソース";
$_lang["new_template"] = "テンプレートの作成";
$_lang["edit_template"] = "テンプレートの編集";
$_lang["new_snippet"] = "スニペットの作成";
$_lang["edit_snippet"] = "スニペットの編集";
$_lang["document_tree"] = "ドキュメントツリー";
$_lang["refresh_tree"] = "ツリーのリフレッシュ";
$_lang["expand_tree"] = "ツリーの展開";
$_lang["collapse_tree"] = "ツリーの縮小";
$_lang["hide_tree"] = "ツリーの非表示";
$_lang["show_tree"] = "ツリーの表示";
$_lang["restore_tree"] = "ツリーのリストア (デフォルトの幅)";
$_lang["help"] = "ヘルプ";
$_lang["credits"] = "謝辞";
$_lang["about"] = "Etomiteについて";
$_lang["rebuild"] = "再構築";
$_lang["menu"] = "メニュー";
$_lang["tree"] = "ツリー";
$_lang["manager"] = "マネージャ";
$_lang["test_page"] = "テストページ";
$_lang["logout"] = "ログアウト";
$_lang["nojava"] = "Javaが使用不可にされているようです。<a href='index.php?a=1&f=9&javaDis=1'>ここをクリック</a>してnon-javaメニューをロードしてください。";
$_lang["confirm_empty_trash"] = "すべての削除済みドキュメントを完全に消去しますか?\\n\\n続けてもよろしいですか?"; // changed 06 RC2
$_lang["unable_set_parent"] = "新しい親ドキュメントを設定できません!";
$_lang["confirm_delete_document"] = "本当にこのドキュメントを削除してもよろしいですか?\\nすべての子ドキュメントも同時に削除されます。";
$_lang["already_deleted"] = "は既に削除されています。";
$_lang["not_deleted"] = "は削除されていません。";
$_lang["confirm_undelete"] = "\\n\\nこのドキュメントおよび関連する子ドキュメントの削除が取り消されます。このドキュメントの削除以前に削除された子ドキュメントは、削除されたままです。";
$_lang["confirm_publish"] = "\\n\\nこのドキュメントを公開することで、設定された公開・公開取り消し日時は上書きされます。公開・公開取り消し日時をそのままにしたい場合、「編集」を選択してください。\\n\\n続けてもよろしいですか?";
$_lang["confirm_unpublish"] = "\\n\\nこのドキュメントの公開を取り消すことで、設定された公開・公開取り消し日時は上書きされます。公開・公開取り消し日時をそのままにしたい場合、「編集」を選択してください。\\n\\n続けてもよろしいですか?";
$_lang["view_document"] = "ドキュメントの表示";
$_lang["edit_document"] = "ドキュメントの編集";
$_lang["move_document"] = "ドキュメントの移動";
$_lang["create_document_here"] = "ここにドキュメントを作成する";
$_lang["create_weblink_here"] = "ここにウェブリンクを作成する";
$_lang["delete_document"] = "ドキュメントの削除";
$_lang["undelete_document"] = "ドキュメントの削除取り消し";
$_lang["publish_document"] = "ドキュメントの公開";
$_lang["unpublish_document"] = "ドキュメントの公開取り消し";
$_lang["all_pending_documents"] = "すべての保留ドキュメント";
$_lang["no_pending_publish"] = "公開を保留したドキュメントはありません。";
$_lang["no_pending_unpublish"] = "公開取り消しを保留したドキュメントはありません。";
$_lang["no_pending_documents"] = "公開または公開取り消しを保留したドキュメントはありません。";
$_lang["published_document"] = "これは公開されたドキュメントです。";
$_lang["unpublished_document"] = "これは公開が取り消されたドキュメントです。";
$_lang["deleted_document"] = "これは削除されたドキュメントです。";
$_lang["published_folder"] = "これは公開されたフォルダです。";
$_lang["unpublished_folder"] = "これは公開が取り消されたフォルダです。";
$_lang["deleted_folder"] = "これは削除されたフォルダです。";
$_lang["published_weblink"] = "これは公開されたウェブリンクです。";
$_lang["unpublished_weblink"] = "これは公開が取り消されたウェブリンクです。";
$_lang["deleted_weblink"] = "これは削除されたウェブリンクです。";
$_lang["published_weblink_folder"] = "これは公開されたウェブリンクフォルダです。";
$_lang["unpublished_weblink_folder"] = "これは公開が取り消されたウェブリンクフォルダです。";
$_lang["deleted_weblink_folder"] = "これは削除されたウェブリンクフォルダです。";
$_lang["recycle_bin"] = "ゴミ箱"; // obsolete
$_lang["empty_recycle_bin"] = "削除済みドキュメントを消去"; // changed 06 rc 2
$_lang["deleted_in_tree"] = "削除済みドキュメントをツリー表示"; // obsolete
$_lang["deleted_in_recycle_bin"] = "ゴミ箱の削除済みドキュメントを表示"; // obsolete
$_lang["recycle_bin_empty"] = "ゴミ箱は空です。"; // obsolete
$_lang["loading_doc_tree"] = "ツリーのローディング中 ...";
$_lang["loading_menu"] = "メニューのローディング中 ...";
$_lang["loading_menu_tree"] = "ドキュメントツリーとメニューのローディング中 ...";
$_lang["working"] = "処理中 ...";
$_lang["show_tree"] = "ツリーの表示";
$_lang["confirm_remove_locks"] = "ユーザは、ドキュメント、テンプレート、スニペット、パーサの編集中にブラウザを閉じることがあります。これらのアイテムは、編集中にロックされた状態で放置されることになります。OKをクリックすることで、現在ロック状態にあるファイルをすべて削除することができます。\\n\\n続けてもよろしいですか?";
$_lang["welcome_title"] = "Etomiteへようこそ";
$_lang["welcome_message"] = "ようこそ、Etomiteへ! 始めるには、画面左のツリーよりドキュメントを選択してください。
または、メインメニューよりメニューオプションを選択してください。 提案、コメントおよび苦情は<a href=''http://www.etomite.com/forums/' target='_blank'>Etomiteサイト</a>へお気軽にどうぞ。
<p>Etomiteのご利用をお楽しみください。<br />The Etomite Development Team"; // Returned 0614
$_lang["welcome_messages"] = "あなたの受信箱には <b>%d</b> 件のメッセージが入っています。<b>%s</b> 件が未読です。";
$_lang["activity_title"] = "最近作成/編集されたドキュメント";
$_lang["activity_message"] = "ここには、あなたが最近作成または編集したドキュメント一覧を表示しています:";
$_lang["no_activity_message"] = "あなたはまだドキュメントを作成または編集していません。";
$_lang["yourinfo_title"] = "あなたの情報";
$_lang["yourinfo_message"] = "ここでは、あなたに関する情報を表示しています:";
$_lang["yourinfo_username"] = "あなたのログイン名は:";
$_lang["yourinfo_role"] = "あなたのロールは:";
$_lang["yourinfo_previous_login"] = "あなたの最終ログイン日時は:";
$_lang["yourinfo_total_logins"] = "合計ログイン回数は:";
$_lang["onlineusers_title"] = "オンラインユーザ";
$_lang["onlineusers_message"] = "ここでは、直近20分以内のアクティブなユーザ一覧を表示しています。現在時刻: ";
$_lang["onlineusers_user"] = "ユーザ";
$_lang["onlineusers_userid"] = "ユーザID";
$_lang["onlineusers_ipaddress"] = "ユーザIPアドレス";
$_lang["onlineusers_lasthit"] = "最終アクセス";
$_lang["onlineusers_action"] = "アクション";
$_lang["configcheck_title"] = "設定チェック";
$_lang["configcheck_notok"] = "1つまたはそれ以上の詳細設定に問題があります: ";
$_lang["configcheck_ok"] = "確認OK - 警告はありません。";
$_lang["configcheck_warning"] = "設定警告:";
$_lang["configcheck_admin"] = "システム管理者に連絡を取って、このメッセージを報告してください!";
$_lang["configcheck_what"] = "どういう意味ですか?";
$_lang["configcheck_installer"] = "インストールプログラムが残されています。";
$_lang["configcheck_installer_msg"] = "install/ ディレクトリにEtomiteのインストールプログラムが残されています。悪意を持った人がインストールプログラムを実行した場合、何が起きるか想像してください! データベースのユーザ情報を入力する必要がありますので、恐らくその先には進めませんが、このフォルダをサーバから削除されることをお勧めします。";
$_lang["configcheck_cache"] = "キャッシュディレクトリに書き込み権がありません。";
$_lang["configcheck_cache_msg"] = "Etomiteは、キャッシュディレクトリにキャッシュファイルを書き込みことができませんでした。Etomiteは要求どおりに動作しますが、キャッシュファイルは保存されません。この問題を解消するには、 /_cache/ ディレクトリに書き込み権を与えてください。";
$_lang["configcheck_lang_difference"] = "言語ファイルのエントリ数が異なります。";
$_lang["configcheck_lang_difference_msg"] = "現在選択されている言語ファイルのエントリ数が、デフォルト言語ファイルのエントリと異なります。特に問題ではありませんが、言語ファイルをアップデートする必要があります。";
$_lang["configcheck_default_msg"] = "特定できない警告が見つかりました。不自然な現象です。";
$_lang["clicktopin"] = "このセクションを固定する。";
$_lang["clicktounpin"] = "このセクションの固定を解除する。";
$_lang["clickonsection"] = "このセクションを展開または縮小する。";
$_lang["edit"] = "編集";
$_lang["save"] = "保存";
$_lang["delete"] = "削除";
$_lang["cancel"] = "キャンセル";
$_lang["find_in_tree"] = "ツリー内を検索"; // obsolete per 06 RC2
$_lang["preview"] = "プレビュー";
$_lang["move"] = "移動";
$_lang["yes"] = "Yes";
$_lang["no"] = "No";
$_lang["online"] = "オンライン";
$_lang["offline"] = "オフライン";
$_lang["advanced"] = "アドバンスト";
$_lang["regular"] = "レギュラー";
$_lang["showing"] = "表示";
$_lang["to"] = "-";
$_lang["total"] = "合計";
$_lang["settings_title"] = "Etomite設定";
$_lang["serveroffset_title"] = "サーバオフセットタイム:";
$_lang["serveroffset_message"] = "サーバ設置場所とあなたの居場所の時差を選択してください。サーバの現在時刻は<b>[%s]</b>です。オフセットを使用したサーバの現在時刻は<b>[%s]</b>です。";
$_lang["sitename_title"] = "サイト名:";
$_lang["sitename_message"] = "あなたのサイト名を入力してください。";
$_lang["sitestart_title"] = "サイトスタート:";
$_lang["sitestart_message"] = "ホームページとして使用するドキュメントのIDを入力してください。<b>注意: 存在しているドキュメントのIDを入力してください。ドキュメントは公開されている必要があります!</b>";
$_lang["errorpage_title"] = "エラーページ:";
$_lang["errorpage_message"] = "ドキュメントが存在しない場合、エラーページとして表示するドキュメントのIDを入力してください。<b>注意: 存在しているドキュメントのIDを入力してください。ドキュメントは公開されている必要があります!</b>";
$_lang["sitestatus_title"] = "サイトステータス:";
$_lang["sitestatus_message"] = "あなたのサイトをウェブ上に公開するには「オンライン」を選択してください。「オフライン」を選択した場合、ビジターには「サイト閉鎖中メッセージ」が表示され、サイトを閲覧することができません。";
$_lang["siteunavailable_title"] = "サイト閉鎖中メッセージ:";
$_lang["siteunavailable_message"] = "オフラインまたはエラー発生時に表示するメッセージです。";
$_lang["friendlyurls_title"] = "ユーザフレンドリーURL:";
$_lang["friendlyurls_message"] = "ここでは、EtomiteがサーチエンジンフレンドリーなURLを使用するよう設定します。この機能は、EtomiteがApacheにインストールされている場合のみ有効です。この機能を動作させるために .htaccessファイルを保存する必要があります。詳細は、Etomiteのディストリビューションに含まれる .htaccessファイルをご覧ください。";
$_lang["friendlyurlsprefix_title"] = "フレンドリーURLの接頭辞:";
$_lang["friendlyurlsprefix_message"] = "ユーザフレンドリーURLの接頭辞を指定してください。例えば、接頭辞を「page」に設定した場合、URLの /index.php?id=2 は、 /page2.htmlというユーザフレンドリーURLに変換されます (接尾辞が .htmlに設定されていると仮定して)。このように、ユーザ (そしてサーチエンジン) が、あなたのサイトを閲覧するためのリンクを指定することができます。"; // updated 0.6 - removed htaccess warning
$_lang["friendlyurlsuffix_title"] = "フレンドリーURLの接尾辞:";
$_lang["friendlyurlsuffix_message"] = "ユーザフレンドリーURLの接尾辞を指定してください。「.html」と指定することにより、すべてのユーザフレンドリーURLの末尾に .htmlが追加されます。"; // updated 0.6 - removed htaccess warning
$_lang["udperms_title"] = "アクセスパーミッションの使用:";
$_lang["udperms_message"] = "アクセスパーミッションを設定することで、どのページをユーザが編集できるか指定することができます。まず、ユーザをユーザグループに、ドキュメントをドキュメントグループに割り当ててください。それから、ユーザグループがアクセスできるドキュメントグループを指定してください。この設定を「Yes」にした場合、最初は管理者のみがすべてのドキュメントを編集することができます。"; // updated 0.6
$_lang["menutype_title"] = "メニュータイプ:";
$_lang["menutype_message"] = "「アドバンストJavaメニュー」または「通常のプレインテキスト」のどちらを使用するか選択してください。[現在、この設定を変更することができません。none-javaメニューを再作成する必要があります、申し訳ございません!]";
$_lang["nologentries_title"] = "ログエントリ数:";
$_lang["nologentries_message"] = "ログ閲覧時、1ページあたりに表示されるログエントリ数を入力してください。";
$_lang["nomessages_title"] = "メッセージ数:";
$_lang["nomessages_message"] = "メッセージ閲覧時、受信ボックスに表示されるメッセージ数を入力してください。";
$_lang["treetype_title"] = "ツリータイプ:";
$_lang["treetype_message"] = "「アドバンスト」を選択すると、ドキュメントステータスに関する情報がドキュメントツリーに表示されます。「レギュラー」は、通常のツリーを表示します。";
$_lang["language_title"] = "言語:";
$_lang["language_message"] = "Etomiteマネージャの使用言語を選択してください。";
$_lang["graphtype_title"] = "グラフタイプ:";
$_lang["graphtype_message"] = "「アドバンスト」を選択すると、レポートグラフのアンチエイリアス処理時にプロセッサのパワーを更に使用します。しかし、グラフが非常に美しく表示されます。";
$_lang["showgraphs_title"] = "グラフの表示:";
$_lang["showgraphs_message"] = "ビジターステータスレポートを作成する場合、表データと同時にグラフを表示しますか?";
$_lang["showtestpage_title"] = "テストページ:";
$_lang["showtestpage_message"] = "作成中のスニペットをテストするためのテストページを使用することができます。あなたがテストページを使用しない場合、「No」をチェックしてメニューから取り除くこともできます。";
$_lang["enabledebug_title"] = "デバッグ:";
$_lang["enabledebug_message"] = "「Yes」を選択すると、Etomiteの異なる機能に関するデバッグ情報を表示します。 通常、この機能は使用しませんが、バグを解消したい場合、「On」を選択してデバッグ情報を表示すると便利です。";
$_lang["doc_data_title"] = "ドキュメントデータ";
$_lang["page_data_title"] = "ページデータ";
$_lang["page_data_general"] = "概要";
$_lang["document_title"] = "タイトル";
$_lang["document_description"] = "説明";
$_lang["page_data_changes"] = "更新履歴";
$_lang["notset"] = "設定なし";
$_lang["page_data_created"] = "作成日時";
$_lang["page_data_edited"] = "更新日時";
$_lang["page_data_status"] = "ステータス";
$_lang["page_data_published"] = "公開";
$_lang["page_data_unpublished"] = "公開取り消し";
$_lang["page_data_publishdate"] = "公開日時";
$_lang["page_data_unpublishdate"] = "公開取り消し日時";
$_lang["page_data_cacheable"] = "キャッシュ";
$_lang["page_data_searchable"] = "検索";
$_lang["page_data_markup"] = "マークアップ/構造";
$_lang["page_data_template"] = "使用テンプレート";
$_lang["page_data_editor"] = "リッチテキストエディタを使用";
$_lang["page_data_folder"] = "フォルダ";
$_lang["page_data_source"] = "ソース";
$_lang["page_data_notcached"] = "このドキュメントは、まだキャッシュされていません。";
$_lang["page_data_cached"] = "<b>キャッシュより抽出されたソース:</b>";
$_lang['cleaningup'] = "クリーンアップ処理中";
$_lang['actioncomplete'] = "<b>処理が正常に完了しました!</b><br /> - Etomiteはクリーンアップ処理中です。お待ちください。";
$_lang['confirm_preview'] = "この機能は役に立ちません!\\n\\n保存されたバージョンのページのみ表示され、あなたが現在編集しているページは表示されません。プレビューを続けますか?";
$_lang['edit_document_title'] = "ドキュメントの作成/編集";
$_lang['document_identification'] = "ドキュメント情報";
$_lang['weblink_message'] = "ウェブリンクは、インターネット上のオブジェクトに対する参照です。オブジェクトは、Etomite内のドキュメント、他のサイトのページや画像、インターネット上の他のファイルです。<p>";
$_lang['weblink'] = "ウェブリンク";
$_lang['document_title_help'] = "ドキュメントの名称/タイトルを入力してください。名称にバックスラッシュを使用しないでください!";
$_lang['document_description_help'] = "ドキュメントに関する任意の説明をここに入力することができます。";
$_lang['document_weblink_help'] = "ウェブリンクで参照したいオブジェクトのアドレスを入力してください。";
$_lang['document_parent'] = "親ドキュメント";
$_lang['document_parent_help'] = "親ドキュメントとして設定したいツリー内のドキュメントをクリックしてください。";
$_lang['document_content'] = "ドキュメントコンテンツ";
$_lang['document_opt'] = "公開";
$_lang['document_opt_folder'] = "フォルダ?";
$_lang['document_opt_richtext'] = "リッチテキスト?";
$_lang['document_opt_published'] = "公開?";
$_lang['document_opt_menu_index'] = "メニューインデックス";
$_lang['document_opt_emptycache'] = "キャッシュのクリア?";
$_lang['document_opt_folder_help'] = "ドキュメントをフォルダとしても扱いたい場合にチェックしてください。Etomiteが自動的にフォルダを設定しますので、あまり心配する必要はありません。";
$_lang['document_opt_richtext_help'] = "ドキュメントの編集にリッチテキストエディタを使用する場合は、チェックしたままにしてください。ドキュメントがJavaスクリプトとフォームを含んでいる場合、エディタがドキュメントを壊さないよう、チェックを外してHTMLモードで編集してください。";
$_lang['document_opt_published_help'] = "保存後、すぐにドキュメントを公開する場合はチェックしてください。";
$_lang['page_data_publishdate_help'] = "公開日時を設定した場合、ドキュメントは公開日時の到来と共に公開されます。カレンダーアイコンをクリックして公開日時を選択するか、カレンダーアイコンの隣のアイコンをクリックして公開日時を削除してください。公開日時を削除すると、ドキュメントは自動的に公開されません。";
$_lang['page_data_unpublishdate_help'] = "公開取り消し日時を設定した場合、公開取り消し日時の到来と共にドキュメントの公開が取り消されます。カレンダーアイコンをクリックして公開取り消し日時を選択するか、カレンダーアイコンの隣のアイコンをクリックして公開取り消し日時を削除してください。公開取り消し日時を削除すると、ドキュメントは自動的に公開取り消しされません。";
$_lang['document_opt_menu_index_help'] = "メニューインデックスは、メニュースニペット内でドキュメントを並び替えるために使用できます。また、スニペット内で他の目的に使用することもできます。";
$_lang['page_data_searchable_help'] = "このフィールドをチェックすることにより、ドキュメントの検索を許可します。スニペットで別の目的に使用することもできます。";
$_lang['page_data_cacheable_help'] = "このフィールドをチェックしたままにすることにより、ドキュメントがキャッシュに保存されることを許可します。ドキュメントにスニペットが含まれている場合、必ずチェックを外してください。";
$_lang['document_opt_emptycache_help'] = "このフィールドをチェックしたままにすることにより、Etomiteはドキュメントが保存された後にキャッシュをクリアします。この設定をすることで、ビジターに古いバージョンのドキュメントが表示されません。";
$_lang['page_data_template_help'] = "ドキュメントが使用するテンプレートを選択してください。";
$_lang['warning_not_saved'] = "変更が保存されていません。変更を保存するため、「キャンセル」をクリックして現在のページに戻ることができます。また、「OK」をクリックしてすべての変更を破棄することもできます。";
$_lang['functionnotimpl'] = "申し訳ございません!";
$_lang['functionnotimpl_message'] = "この機能は、まだ実装されていません。";
$_lang['move_document_title'] = "ドキュメントの移動";
$_lang['move_document_message'] = "ツリー内の新しい親ドキュメントを選択して、ドキュメントおよび子ドキュメントを移動することができます。フォルダではないドキュメントを親ドキュメントとして選択した場合、ドキュメントはフォルダに変更されます。 ツリー内の新しい親ドキュメントをクリックしてください。";
$_lang['document_to_be_moved'] = "移動対象ドキュメント";
$_lang['move_document_new_parent'] = "ドキュメントツリーより新しい親を選択してください。";
$_lang['new_parent'] = "新しい親ドキュメント";
$_lang['edit_parser_title'] = "パーサの編集";
$_lang['edit_parser_warning'] = "<b style='color:#821517'>このファイルを編集することで、あなたのサイトに重大な障害が発生する場合があります!</b><br />現在、あなたはPHPファイルを直接編集しています。保存する前に、この内容を (ノートパッドまたは他のもので) バックアップしてください!";
$_lang['change_password_message'] = "新しいパスワードを入力して、確認のためのパスワードをもう一度入力してください。パスワードの長さは半角6～15文字の間にしてください。";
$_lang['change_password_new'] = "新しいパスワード";
$_lang['change_password_confirm'] = "パスワードをもう一度";
$_lang['personal_prefs_title'] = "詳細設定";
$_lang['personal_prefs_message'] = "現在、ユーザベースで詳細設定を変更することはできません。将来的に、このセクションは言語オプション等の設定を上書きできるようになります。設定を変更するには、Etomite設定を編集してください。";
$_lang['confirm_delete_role'] = "本当にこのロールを削除してもよろしいですか?";
$_lang['role_title'] = "ロールの作成/編集";
$_lang['role_name'] = "ロール";
$_lang['role_content_management'] = "コンテンツ管理";
$_lang['role_template_management'] = "テンプレート管理";
$_lang['role_snippet_management'] = "スニペット管理";
$_lang['role_user_management'] = "ユーザ管理";
$_lang['role_udperms'] = "パーミッション管理";
$_lang['role_role_management'] = "ロール管理";
$_lang['role_config_management'] = "設定管理";
$_lang['role_frames'] = "マネージャフレーム";
$_lang['role_home'] = "マネージャ紹介ページ";
$_lang['role_messages'] = "メッセージの表示および送信";
$_lang['role_logout'] = "マネージャのログアウト";
$_lang['role_help'] = "ヘルプページの表示";
$_lang['role_actionok'] = "処理完了ページの表示";
$_lang['role_errors'] = "エラーダイアログの表示";
$_lang['role_about'] = "「Etomiteについて」ページの表示";
$_lang['role_credits'] = "謝辞の表示";
$_lang['role_change_password'] = "パスワードの変更";
$_lang['role_save_password'] = "パスワードの保存";
$_lang['role_view_docdata'] = "ドキュメントデータの表示";
$_lang['role_create_doc'] = "ドキュメントの作成";
$_lang['role_edit_doc'] = "ドキュメントの編集";
$_lang['role_save_doc'] = "ドキュメントの保存";
$_lang['role_delete_doc'] = "ドキュメントの削除";
$_lang['role_cache_refresh'] = "キャッシュのクリア";
$_lang['role_create_template'] = "テンプレートの作成";
$_lang['role_edit_template'] = "テンプレートの編集";
$_lang['role_save_template'] = "テンプレートの保存";
$_lang['role_delete_template'] = "テンプレートの削除";
$_lang['role_create_snippet'] = "スニペットの作成";
$_lang['role_edit_snippet'] = "スニペットの編集";
$_lang['role_save_snippet'] = "スニペットの保存";
$_lang['role_delete_snippet'] = "スニペットの削除";
$_lang['role_new_user'] = "ユーザの作成";
$_lang['role_edit_user'] = "ユーザの編集";
$_lang['role_save_user'] = "ユーザの保存";
$_lang['role_delete_user'] = "ユーザの削除";
$_lang['role_access_persmissions'] = "パーミッション";
$_lang['role_new_role'] = "ロールの作成";
$_lang['role_edit_role'] = "ロールの編集";
$_lang['role_save_role'] = "ロールの保存";
$_lang['role_delete_role'] = "ロールの削除";
$_lang['role_view_logs'] = "システムログの閲覧";
$_lang['role_edit_parser'] = "サイトパーサの編集";
$_lang['role_save_parser'] = "サイトパーサの保存";
$_lang['role_edit_settings'] = "サイト設定の変更";
$_lang['role_file_manager'] = "ファイルマネージャの使用";
$_lang['confirm_unblock'] = "本当にこのユーザのアクセス拒否を解除してもよろしいですか?";
$_lang['unblock_message'] = "ユーザデータを保存した後、このユーザのアクセス拒否は解除されます。";
$_lang['confirm_block'] = "本当にこのユーザのアクセスを拒否してもよろしいですか?";
$_lang['block_message'] = "ユーザデータを保存した後、このユーザはアクセス拒否されます!";
$_lang['confirm_delete_user'] = "本当にこのユーザを削除してもよろしいですか?";
$_lang['alert_delete_self'] = "あなた自身を削除することはできません!";
$_lang['user_title'] = "ユーザの作成/編集";
$_lang['user_is_blocked'] = "このユーザはアクセス拒否されています!";
$_lang['password'] = "パスワード";
$_lang['password_gen_method'] = "どのようにパスワードを作成しますか?";
$_lang['password_gen_gen'] = "Etomiteにパスワードを生成させる。";
$_lang['password_gen_specify'] = "パスワードを指定する:";
$_lang['password_method'] = "どのようにパスワードを通知しますか?";
$_lang['password_method_email'] = "新しいパスワードをメールで通知する。";
$_lang['password_method_screen'] = "新しいパスワードを画面に表示する。";
$_lang['password_msg'] = "<b>%s</b>の新しいパスワードは<b>%s</b>です。";
$_lang['user_full_name'] = "フルネーム";
$_lang['user_email'] = "メールアドレス";
$_lang['user_phone'] = "電話番号";
$_lang['user_mobile'] = "携帯電話番号";
$_lang['user_role'] = "ユーザロール";
$_lang['user_logincount'] = "ログイン回数";
$_lang['user_prevlogin'] = "最終ログイン";
$_lang['user_failedlogincount'] = "ログイン失敗";
$_lang['user_block'] = "アクセス拒否";
$_lang['user_edit_self_msg'] = "あなたのユーザ情報を変更した場合、変更を反映させるためにログアウトして、再度ログインしてください。</b><br />新しいパスワードの作成をチェックした場合、新しいパスワードがメール送信されます。";
$_lang['confirm_delete_snippet'] = "本当にこのスニペットを削除してもよろしいですか?";
$_lang['snippet_title'] = "スニペットの作成/編集";
$_lang['snippet_msg'] = "ここでは、スニペットを追加/編集することができます。スニペットは「生の」PHPコードです。スニペットのアウトプットをテンプレートの特定の場所に表示したい場合、テンプレート内にスニペット自身と同じ名前の変数を記述する必要があります - 基本的にスニペットのアウトプットは、スニペット自身と同じ名前で保存された変数を必要とします。";
$_lang['snippet_name'] = "スニペット名";
$_lang['snippet_desc'] = "スニペット説明";
$_lang['confirm_delete_template'] = "本当にこのテンプレートを削除してもよろしいですか?";
$_lang['template_title'] = "テンプレートの作成/編集";
$_lang['template_msg'] = "テンプレートを作成/編集できます。 作成・変更されたテンプレートは、キャッシュがクリアされるまで、キャッシュされるページで見ることができません。 しかし、プレビュー機能を使用してテンプレートの動作を確認することはできます。";
$_lang['template_name'] = "テンプレート名";
$_lang['template_desc'] = "テンプレート説明";
$_lang['refresh_title'] = "サイトのリフレッシュ";
$_lang['refresh_published'] = "<b>%s</b>件のドキュメントが公開されました。";
$_lang['refresh_unpublished'] = "<b>%s</b>件のドキュメントの公開が取り消されました。";
$_lang['refresh_cache'] = "キャッシュ: キャシュディレクトリの<b>%s</b>個のキャッシュファイル中<b>%d</b>個のキャッシュファイルが削除されました。<p>ページがリクエストされた時点で、新しいキャッシュファイルが生成されます。"; // changed in 0.6
$_lang['about_title'] = "Etomiteについて";
$_lang['about_msg'] = "Etomite was written by Alex, and is licensed under <a href=\"../assets/docs/license.txt\">GPL</a>."; //changed 06 RC2
$_lang['credits_htmlarea'] = "HTMLArea was created by mishoo. Currently it's the only cross-browser compatible editor available, and it's free too!"; // obsolete
$_lang['credits_adodb'] = "John Lim built this great database abstraction layer. Etomite uses only the MySQL bits, but it's lovely nonetheless!"; // obsolete
$_lang['credits_php'] = "Etomite is powered by PHP!"; // obsolete
$_lang['credits_mysql'] = "Etomite is powered by MySQL!"; // obsolete
$_lang['credits_vorx'] = "Vorx kindly hosts the etomite.org domain, home of Etomite!"; // obsolete
$_lang['credits_phpBB'] = "The Etomite forums are powered by phpBB!"; // obsolete
$_lang['credits_mantis'] = "The Etomite bugtracker is powered by Mantis!"; // obsolete
$_lang['credits_webfx'] = "Etomite uses a number of JavaScripts from Webfx. Great stuff!"; // obsolete
$_lang['credits_dTree'] = "Etomite uses the excellent dTree script from DestroyDrop.com!"; // obsolete
$_lang['credits_jpgraph'] = "Etomite uses JpGraph to generate visitor statistics!"; // obsolete
$_lang['credits_shouts_title'] = "<b>My thanks to:</b>"; // obsolete
$_lang['credits_shouts_msg'] = "
<ul><li><b>Jorg Diederen</b> - Dutch translation</li>
<li><b>Anders Monrad</b> - Danish translation</li>
<li><b>Evaldas Stulgaitis</b> - Lithuanian translation</li>
<li><b>Luis Lacerda</b> - Portuguese translation</li>
<li><b>Johnny Chadda</b> - Swedish translation</li>
<li><b>Tobias Nix</b> - German translation</li>
<li><b>Espen O. Pedersen</b> - Norwegian translation</li>
<li><b>Mitsuhiro Yoshida</b> - Japanese translation</li>
<li><b>stevew</b> - code for rewriting IMG src's as relative paths</li>
<li><b>Ron & Ivo</b> - testing</li>
<li><b>Snuffkin</b> - finding bugs, forum moderation and administration, download mirroring, quality control, quality assurance, nitpicking, Good Idea Guy</li>
<li>Everyone who has provided feedback on Etomite, or suggested new features, or who have donated money to thank me for my hard work. Thanks guys!</li></ul>"; // changed (this changes almost every release)  // obsolete
$_lang['messages_title'] = "メッセージ";
$_lang['messages_inbox'] = "受信箱";
$_lang['messages_read_message'] = "メッセージ";
$_lang['messages_compose'] = "メッセージの作成";
$_lang['messages_not_allowed_to_read'] = "あなたはこのメッセージを読むことはできません!";
$_lang['messages_system_user'] = "[System]";
$_lang['messages_reply'] = "返信";
$_lang['messages_forward'] = "転送";
$_lang['messages_from'] = "From";
$_lang['messages_sent'] = "送信日時";
$_lang['messages_subject'] = "件名";
$_lang['messages_no_messages'] = "受信箱にメッセージがありません。";
$_lang['messages_private'] = "プライベート";
$_lang['messages_category'] = "カテゴリ";
$_lang['messages_send_to'] = "送信先";
$_lang['messages_user'] = "ユーザ";
$_lang['messages_group'] = "グループ";
$_lang['messages_all'] = "全員";
$_lang['messages_select_user'] = "ユーザの選択";
$_lang['messages_select_group'] = "グループの選択";
$_lang['messages_message'] = "メッセージ";
$_lang['messages_send'] = "送信";
$_lang['files_title'] = "ファイルブラウザ";
$_lang['files_files'] = "ファイル";
$_lang['files_filetype_notok'] = "このタイプのファイルはアップロードできません!";
$_lang['files_upload_ok'] = "ファイルのアップロードが完了しました!";
$_lang['files_upload_copyfailed'] = "コピー先ディレクトリへのファイルコピーが失敗しました - アップロード失敗!";
$_lang['files_upload_error'] = "エラー";
$_lang['files_upload_error0'] = "アップロードに問題が発生しました。";
$_lang['files_upload_error1'] = "あなたがアップロードしようとしたファイルが大きすぎます。";
$_lang['files_upload_error2'] = "あなたがアップロードしようとしたファイルが大きすぎます。";
$_lang['files_upload_error3'] = "あなたがアップロードしようとしたファイルは一部分のみアップロードされました。";
$_lang['files_upload_error4'] = "アップロードするファイルを選択してください。";
$_lang['files_upload_error5'] = "アップロード中に問題が発生しました。";
$_lang['files_dir_listing'] = "ディレクトリ一覧:";
$_lang['files_access_denied'] = "アクセスが拒否されました!";
$_lang['files_top_level'] = "トップレベルへ移動する";
$_lang['files_up_level'] = "1レベル上へ移動する";
$_lang['files_filename'] = "ファイル名";
$_lang['files_modified'] = "更新日時";
$_lang['files_filesize'] = "ファイルサイズ";
$_lang['files_fileoptions'] = "オプション";
$_lang['files_directories'] = "ディレクトリ";
$_lang['files_data'] = "データ";
$_lang['files_dirwritable'] = "ディレクトリ書き込み可?";
$_lang['files_uploadfile'] = "ファイルのアップロード";
$_lang['files_uploadfile_msg'] = "アップロードするファイルを選択してください:";
$_lang['files_upload_inhibited_msg'] = "<b>アップロード機能が使用できません。</b> - アップロードがサポートされているか、ディレクトリに書き込み権があるか確認してください。<br />";
$_lang['files_editfile'] = "ファイルの編集";
$_lang['files_viewfile'] = "ファイルの表示";
$_lang['files_file_upload'] = "ファイルのアップロード";
$_lang['files_uploading'] = "<b>%s</b>を<b>%s/</b>にアップロードしました。<br />";
$_lang['files_file_type'] = "ファイルタイプ: ";
$_lang['search'] = "検索";
$_lang['search_criteria'] = "検索クリテリア";
$_lang['search_criteria_id'] = "IDで検索";
$_lang['search_criteria_title'] = "タイトルで検索";
$_lang['search_criteria_content'] = "コンテンツで検索";
$_lang['search_criteria_id_msg'] = "ドキュメントを特定するためのドキュメントIDを入力してください。";
$_lang['search_criteria_title_msg'] = "入力されたテキストですべてのドキュメントのタイトルを検索します。";
$_lang['search_criteria_content_msg'] = "入力されたテキストですべてのドキュメントのコンテンツを検索します。";
$_lang['search_results'] = "検索結果";
$_lang['search_empty'] = "あなたが指定したデータが見つかりませんでした。検索範囲を広げて再度検索してください。";
$_lang['search_results_returned_msg'] = "<b>%s</b>件のデータが見つかりました。多くの検索結果が表示される場合は、検索範囲を更に狭くしてください。左側２つのカラムでは、ツリーでドキュメントを探したり、ドキュメントを表示したりすることができます。右側２つのカラムでは、 ドキュメントの削除状態および公開状態が各々表示されます。<p />";
$_lang['search_results_returned_id'] = "ID";
$_lang['search_results_returned_title'] = "タイトル";
$_lang['search_results_returned_desc'] = "説明";
$_lang['search_view_docdata'] = "このアイテムを表示する";
$_lang['search_item_deleted'] = "このアイテムは削除されています。";
$_lang['help_title'] = "ヘルプ";
$_lang['help_msg'] = "Etomiteの使用で分からないことがある場合、<a href='http://forums.etomite.org' target='_blank'>Etomiteフォーラム</a>への訪問をお勧めします。<a href='http://wiki.etomite.org' target='_blank'>Etomiteサイト</a>にも、Etomiteの使用またはセットアップに関する情報が掲載されていますので、あなたが探している情報があるかもしれません。もし、探している情報が無い場合、Etomiteフォーラムに質問を投稿してください。可能な限り早急にお答えします。";
$_lang['configcheck_images'] = "イメージディレクトリに書き込み権がありません";
$_lang['configcheck_images_msg'] = "イメージディレクトリに書き込み権が無い、またはイメージディレクトリが存在していません。エディタのイメージマネージャ機能が動作しません!";
$_lang['php_version_check'] = "Etomiteは、PHPバージョン4.0.3またはそれ以上で動作します。あなたのインストール済みPHPをアップグレードしてください!";
$_lang['document_alias'] = "ドキュメントエイリアス";
$_lang['document_alias_help'] = "このドキュメントのエイリアスを指定することができます。次のようにドキュメントにアクセスすることができます:\n\nhttp://yourserver/エイリアス\n\nエイリアスは、フレンドリーURLを使用する場合のみ動作します。";
$_lang['etomite_slogan'] = "Fast, Free, Ultimately Flexible - \nEtomite Content Management";
$_lang['user_management_title'] = "ユーザ管理";
$_lang['user_management_msg'] = "編集したいユーザを選択してください。";
$_lang['role_management_title'] = "ロール管理";
$_lang['role_management_msg'] = "編集したいロールを選択してください。";
$_lang['manage_templates'] = "テンプレート管理";
$_lang['template_management_msg'] = "編集したいテンプレートを選択してください。";
$_lang['manage_snippets'] = "スニペット管理";
$_lang['snippet_management_msg'] = "編集したいスニペットを選択してください。";
$_lang['resource_management'] = "リソース管理";
$_lang['parser_not_writable'] = "あなたが編集しようとしているパーサに書き込み権がありません。続ける前に、ファイルに (FTPまたはホストのコントロールパネルを使って) 書き込み権を与えてください。"; //obsolete
$_lang['server_protocol_title'] = "サーバタイプ:";
$_lang['server_protocol_message'] = "あなたのサイトがSSL接続を使用している場合、httpsを選択してください。";
$_lang['server_protocol_http'] = "http";
$_lang['server_protocol_https'] = "https";
$_lang['to_plugin_title'] = "テーブル操作:";
$_lang['to_plugin_message'] = "[HTMLAreaのみ] - ドキュメントエディタで拡張テーブルを操作しますか?"; // changed 06 RC2
$_lang['im_plugin_title'] = "イメージマネージャ:";
$_lang['im_plugin_message'] = "[HTMLAreaのみ] - ドキュメントエディタでイメージマネージャを使用しますか? この機能により、ユーザはサーバへのイメージアップロードおよびアップロードしたイメージを編集することができます。"; // changed 06 RC2
$_lang['cm_plugin_title'] = "コンテキストメニュー:";
$_lang['cm_plugin_message'] = "[HTMLAreaのみ] - ドキュメントエディタでコンテキストメニューを使用しますか?"; // changed 06 RC2
$_lang['server_info'] = "サーバ情報"; // changed 0.6.1
$_lang['settings_server'] = "サーバ設定"; // deprecated
$_lang['settings_site'] = "サイト設定";
$_lang['settings_furls'] = "フレンドリーURL設定";
$_lang['settings_users'] = "ユーザ設定"; //changed 0.6 - shortened
$_lang['settings_ui'] = "インターフェース&エディタ設定"; //changed 0.6 - added editor
$_lang['use_doc_editor_title'] = "ドキュメントエディタを有効にする:";
$_lang['use_doc_editor_message'] = "ドキュメントの編集にリッチテキストエディタを使用しますか? HTMLを記述した方が快適な場合、この設定でエディタの使用を無効にしてください。この設定はすべてのドキュメントおよびユーザに適用されますので注意してください!";
$_lang['use_code_editor_title'] = "スニペット/チャンクエディタを有効にする:";
$_lang['use_code_editor_message'] = "スニペットおよびチャンクエディタのためシンタックスハイライトを有効にしますか? この設定により、行番号への移動、検索/置換、トグリング、インデント/タブ等の行番号がシンタックスカラーリングされます。";
$_lang['code_highlight_title'] = "コードハイライティング:";
$_lang['code_highlight_message'] = "コードハイライティング設定により、パフォーマンスが落ちる場合があります。ハイライティングのスピードを元に戻すには、ハイライティングを無効にしてください。Yes = シンタックスカラーリングを含むすべての機能を有効にします。 No = シンタックスカラーリングを除くすべての機能 (行番号、検索等) を無効にします";
$_lang['signupemail_title'] = "サインアップメール:";
$_lang['signupemail_message'] = "ユーザアカウントの作成時、ユーザに送信されるメッセージを設定してください。Etomiteは、ユーザ名とパスワードが記載されたメールを送信します。<b>注意:</b> %s コードは、メッセージの送信時にEtomiteによって置き換えられます。最初の %s は常にユーザ名と置き換えられ、2番目はパスワードに置き換えられます。<b>メール内の2つの %s コードはそのままにしてください。% を削除するとユーザ名とパスワードが送信されず、ユーザがユーザ名とパスワードを知ることができません!</b>";
$_lang['emailsender_title'] = "メールアドレス:";
$_lang['emailsender_message'] = "ユーザにユーザ名およびパスワード送信時の送信元メールアドレスを指定してください。";
$_lang['emailsubject_title'] = "メール件名:";
$_lang['emailsubject_message'] = "サインアップメールの件名を指定してください。";
$_lang['im_plugin_base_dir_title'] = "イメージディレクトリのパス:";
$_lang['im_plugin_base_dir_message'] = "[HTMLAreaのみ] - 通常、この設定は自動的に生成されます。もし、あなたがIISを使用しているのでしたら、Etomiteがパスを判別できないため、イメージマネージャがエラーを表示することがあります。この場合、イメージディレクトリのパスをここに入力することができます (パスはWindowsエクスプローラに表示されるものを参考にしてください)。"; // changed 0.6 RC2
$_lang['im_plugin_base_url_title'] = "イメージディレクトリのURL:";
$_lang['im_plugin_base_url_message'] = "[HTMLAreaのみ] - 通常、この設定は自動的に生成されます。もし、あなたがIISを使用しているのでしたら、EtomiteがURLを判別できないため、イメージマネージャがエラーを表示することがあります。この場合、イメージディレクトリのURLをここに入力することができます (URLはInternet Explorerに表示されるものを参考にしてください)。"; // changed 0.6 RC2
$_lang['stay'] = "保存後に続けて編集する";
$_lang['saving'] = "保存中、お待ちください ...";
$_lang['charset_title'] = "エンコーディング:";
$_lang['charset_message'] = "マネージャで使用したいエンコーディングを選択してください。数多くのエンコードでテストしていますが、すべてではないことをご理解ください。ほとんどの言語では、デフォルト設定のISO-8859-1をお使いください。";
$_lang['reset_failedlogins'] = "リセット";
$_lang['untitled_document'] = "無題のドキュメント";
$_lang['untitled_weblink'] = "無題のウェブリンク";
$_lang['layout_settings_title'] = "レイアウト設定"; // deprecated
$_lang['layout_title'] = "マネージャレイアウト:";
$_lang['layout_message'] = "Etomiteマネージャのレイアウトを選択してください。";
$_lang['layout_settings_2'] = "レイアウト 2 - ナビゲーションを画面上部に配置する。現在はIEのみで動作します。";
$_lang['layout_settings_1'] = "レイアウト 1 - ナビゲーションをドキュメントツリーの上に配置する。";
$_lang['loading_page'] = "Etomiteはページをロードしています。お待ちください ...";
$_lang['filemanager_path_title'] = "ファイルマネージャパス:";
$_lang['filemanager_path_message'] = "多くの場合、IISはドキュメントルートの設定を適切に渡しません。ドキュメントルート情報は、ファイルマネージャであなたが何を見ることができるか決定するために使用されます。ファイルマネージャの使用で問題がある場合、このパスがインストール済みEtomiteのルートディレクトリを指しているか確認してください。";
$_lang['password_gen_length'] = "パスワードは少なくとも6文字以上の長さにしてください。";
$_lang['captcha_code'] = "セキュリティーコード";
$_lang["login_captcha_message"] = "管理者がCaptcha認証を設定しています。表示されているセキュリティーコードを入力してください。セキュリティコードが読めない場合、コードの画像をクリックして新しいランダムコードを再生成してください。";
$_lang['captcha_title'] = "CAPTCHAコードの使用:";
$_lang['captcha_message'] = "この設定では、機械 (およびscriptkiddyなハッキングスクリプト) で読み取ることのできないコードをユーザに入力させることで、セキュリティレベルを上げることができます。";
$_lang['lock_snippet'] = "スニペットの編集をロック";
$_lang['lock_snippet_msg'] = "管理者 (ロールID 1) のみ編集できます。";
$_lang['snippet_locked_message'] = "このスニペットはロックされています。";
$_lang['lock_template'] = "テンプレートの編集をロック";
$_lang['lock_template_msg'] = "管理者 (ロールID 1) のみ編集できます。";
$_lang['template_locked_message'] = "このテンプレートはロックされています。";
$_lang['administrator_role_message'] = "このロールは編集および削除できません。";
$_lang['visitor_stats_online'] = "閲覧中のビジター";
$_lang['track_visitors_title'] = "訪問の記録";
$_lang['track_visitors_message'] = "訪問の記録を取ることにより、あなたのサイトの利用統計を見ることができます。しかし、サイトのレスポンスが若干遅くなります。あなたが、訪問者の統計を気にしないのでしたら、このオプションを停止してスピードアップを楽しんでも問題ありません。";
$_lang['friendly_alias_title'] = "フレンドリーエイリアス";
$_lang['friendly_alias_message'] = "あなたがフレンドリーURLを使用して、ドキュメントがエイリアスを持つ場合、エイリアスは常にフレンドリーURLに優先します。このオプションを「Yes」に設定することで、フレンドリーURLの接頭辞と接尾辞もエイリアスに適用されます。例えば、ドキュメントのIDが1、エイリアスが「introduction」、接頭辞が「」、接尾辞が「.html」の場合、このオプションを「Yes」にすると、URLは「introduction.html」となります。 エイリアスを設定していない場合、Etomiteが「1.html」というリンクを生成します。";
$_lang['no_stats_message'] = "通常このセクションでは訪問者の統計を表示しますが、Etomiteの設定で「訪問の記録」が「No」に設定されています。訪問者に関する情報は収集されません。";
$_lang['welcome_visitor_stats'] = "ここでは、あなたのサイトの訪問者統計を表示しています。詳細情報は「ビジターステータス」ページをご覧ください。<br /><br />";
$_lang['page_impressions'] = "ページインプレッション";
$_lang['visitors'] = "ユニークビジター";
$_lang['visits'] = "訪問件数";
$_lang['all_time'] = "全期間";
$_lang['this_month'] = "今月";
$_lang['today'] = "本日";
$_lang['document_visitor_stats'] = "<br /><br />このドキュメントの訪問者統計を表示しています:<br />";
$_lang['resolve_hostnames_title'] = "ホスト名解決";
$_lang['resolve_hostnames_message'] = "ビジターがあなたのサイトを訪れた場合、Etomiteでホスト名を解決しますか? ホスト名を解決することにより、サーバロードが多少増加します。しかし、ビジターがこのことに気付くことはありません。";
$_lang['stats_title'] = "%s のビジター統計 %s から %s まで";
$_lang['stats_monthly_breakup'] = "月別統計";
$_lang['stats_daily_breakup'] = "日間統計";
$_lang['stats_hourly_breakup'] = "時間別統計";
$_lang['months'] = array("1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月");
$_lang['days'] = array("日", "月", "火", "水", "木", "金", "土");
$_lang['top_howmany_title'] = "トップ表示件数";
$_lang['top_howmany_message'] = "レポートを表示する場合、「トップ...」リストの表示件数は?";
$_lang['stats_top_pages'] = "トップ %s ドキュメント";
$_lang['document'] = "ドキュメント";
$_lang['rank'] = "ランク";
$_lang['stats_top_referrers'] = "トップ %s リファラーページ";
$_lang['referrer'] = "リファラー";
$_lang['stats_top_ua'] = "トップ %s ユーザエージェント";
$_lang['ua'] = "ユーザエージェント";
$_lang['stats_top_os'] = "トップ %s オペレーティングシステム";
$_lang['os'] = "オペレーティングシステム";
$_lang['visitors_used_this'] = "利用数";
$_lang['visitors_came_from_here'] = "訪問数";
$_lang['no_results'] = "該当なし";
$_lang['no_online_users'] = "現在、あなたのサイトを閲覧しているビジターはいません。";
$_lang['stats_top_hosts'] = "トップ %s ホスト";
$_lang['hostname'] = "ホスト名";
$_lang['unknown_referer'] = "不明/ 直接/ ブックマーク";
$_lang['internal_referer'] = "サイト内部参照";
$_lang['stats_top_entrypages'] = "トップ %s エントリドキュメント";
$_lang['visits_started_here'] = "開始ドキュメント";
$_lang['no_logging_found'] = "データベースにログデータが見つかりませんでした。これは、訪問の記録が「No」にされているか、あなたのサイトにまだビジターが訪問していないことを意味します。";
$_lang['visitor_online'] = "あなたのサイトを閲覧中のビジター";
$_lang['visitor_online_message'] = "ここでは、直近20分以内のアクティブなビジターを表示しています (<b>%s</b>以降)。";
$_lang['access_permission_denied'] = "あなたには、このドキュメントにアクセスする権限がありません。"; // changed 0.6 RC2
$_lang['warning'] = "警告!";
$_lang['documents'] = "ドキュメント";
$_lang['sysinfo_activity_message'] = "ここでは、最近どのドキュメントがユーザによって編集されたか表示します。";
$_lang['datechanged'] = "更新日時";
$_lang['sysinfo_userid'] = "ユーザ";
$_lang['id'] = "ID";
$_lang['settings_after_install'] = "新たにインストールされたEtomiteのため、これらの設定を行ってください。設定完了後、データベースを更新するため、「保存」ボタンをクリックしてください。<br /><br />";
$_lang['settings_misc'] = "その他の設定";
$_lang["udperms_allowroot_title"] = "ルートディレクトリの許可:";
$_lang["udperms_allowroot_message"] = "サイトのルートディレクトリにユーザがドキュメント/フォルダを作成できるようにしますか? ";
$_lang['access_permission_parent_denied'] = "あなたはここにドキュメントを作成する権限がありません!";
$_lang["new_htmlsnippet"] = "チャンクの作成";
$_lang["edit_htmlsnippet"] = "チャンクの編集";
$_lang['manage_htmlsnippets'] = "チャンク管理";
$_lang['htmlsnippet_management_msg'] = "編集したいチャンクを選択してください。";
$_lang['confirm_delete_htmlsnippet'] = "本当にこのチャンクを削除してもよろしいですか?";
$_lang['htmlsnippet_title'] = "チャンクの作成/編集";
$_lang['htmlsnippet_msg'] = "ここでは、チャンクを追加/編集することができます。チャンクは「生の」HTMLコードです。PHPコードは動作しないことに注意してください。";
$_lang['htmlsnippet_name'] = "チャンク名";
$_lang['htmlsnippet_desc'] = "チャンク説明";
$_lang['lock_htmlsnippet'] = "チャンクの編集をロック";
$_lang['lock_htmlsnippet_msg'] = "管理者 (ロールID 1) のみ編集できます。";
$_lang['htmlsnippet_locked_message'] = "このチャンクはロックされています。";
$_lang['use_strict_editor_title'] = "ストリクトエディタ:";
$_lang['use_strict_editor_message'] = "[HTMLAreaのみ] - この設定を「Yes」にした場合、HTMLAreaが出力するXHTMLに準拠しないコードを取り除きます。";
$_lang['access_permissions_user_groups'] = "ユーザグループ";
$_lang['access_permissions_document_groups'] = "ドキュメントグループ";
$_lang["access_permissions_links"] = "ユーザ/ドキュメントグループリンク";
$_lang['rename'] = "リネーム";
$_lang['remove'] = "削除 ->";
$_lang['add'] = "グループの追加";
$_lang['access_permissions_introtext'] = "ここでは、アクセスパーミッションのための、ユーザグループとドキュメントグループを管理することができます。ユーザをグループに追加するには、ユーザ編集の画面でメンバーとして追加するユーザグループを選択してください。ドキュメントをドキュメントグループに追加するには、ドキュメント編集画面で属させたいドキュメントグループを選択してください。";
$_lang["access_permissions_add_user_group"] = "ユーザグループの作成";
$_lang["access_permissions_add_document_group"] = "ドキュメントグループの作成";
$_lang['no_groups_found'] = "グループが見つかりません。";
$_lang['access_permissions_user_group'] = "ユーザグループ:";
$_lang['access_permissions_user_group_access'] = "このユーザグループがアクセス可能なドキュメントグループ:";
$_lang['access_permissions_users_in_group'] = "<b>グループ内ユーザ:</b> ";
$_lang['access_permissions_no_users_in_group'] = "なし";
$_lang['access_permissions_documents_in_group'] = "<b>グループ内ドキュメント:</b> ";
$_lang['access_permissions_no_documents_in_group'] = "なし";
$_lang['access_permissions_docs_message'] = "このドキュメントを属させたいドキュメントグループを選択してください:";
$_lang['access_permissions_users_message'] = "このユーザを属させたいユーザグループを選択してください:";
$_lang['access_permissions_users_tab'] = "ここでは、どのユーザグループが設定されているか閲覧することができます。あなたはグループを作成、リネーム、削除することもできます。また、ユーザがどのグループのメンバーになっているか閲覧することもできます。ユーザをグループに追加・削除するには、ユーザを直接編集してください。管理者 (ロールID 1が割り当てられているユーザ) は、常にすべてのドキュメントにアクセスすることができます。ですから、管理者をグループに追加する必要はありません。";
$_lang['access_permissions_documents_tab'] = "ここでは、どのドキュメントグループが設定されているか閲覧することができます。あなたはグループを作成、リネーム、削除することもできます。 また、ドキュメントがどのグループに属しているか閲覧することもできます (ドキュメント名を表示するには、idの上にマウスポインタを乗せてください)。 ドキュメントをグループに追加・削除するには、ドキュメントを直接編集してください。";
$_lang['access_permissions_links_tab'] = "ここでは、どのユーザグループがドキュメントグループにアクセス (例 編集、子ドキュメントの作成) できるか指定します。ドキュメントグループをユーザグループに関連付けるには、ドロップダウンメニューよりドキュメントグループを選択して、「グループの追加」をクリックしてください。ドキュメントグループとの関連付けを削除するには、「削除 ->」をクリックしてください。この作業により、関連付けが直ぐに解除されます。";
$_lang['access_permissions_off'] = "<span class='warning'>アクセスパーミッションが停止されています。</span> アクセスパーミッションが開始されるまで、変更された設定内容は反映されません。";
$_lang["settings_strip_image_paths_title"] = "イメージパスの上書き?";
$_lang["settings_strip_image_paths_message"] = "この設定を「Yes」にした場合、Etomiteはイメージソースのパスを絶対パスから相対パスに書き換えます。これは、インストール済みEtomiteを移動したい時に大変便利です (例えば、開発サイトから正式サイトへの移行)。このことが何を意味しているのか理解できない場合、「No」を選択されることをお勧めします。";
$_lang["uploadable_files_title"] = "アップロード可能なファイルタイプ:";
$_lang["uploadable_files_message"] = "ファイルマネージャを使用してアップロードできるファイルタイプの一覧を入力してください。ファイルタイプの拡張子をカンマで区切って入力してください。";
$_lang["keywords"] = "キーワード";
$_lang["keyword"] = "キーワード";
$_lang["manage_keywords"] = "キーワード管理";
$_lang["document_keywords_help"] = "このドキュメントに割り当てるキーワードを選択してください。CTRLキーを押したまま選択することにより、複数のキーワードを選択できます。";
$_lang["keywords_message"] = "サイトのキーワードを管理します。";
$_lang["keywords_intro"] = "ここでは、キーワードを削除・作成・編集することができます。ドキュメントにキーワードを関連付けるには、ドキュメントを編集して、リストからキーワードを選択してください。キーワードを編集するには、キーワードの隣にあるテキストフィールドの内容を書き換えてください。キーワードを削除するには、削除したいキーワードの「削除」ボックスをチェックしてください。キーワード削除ボックスをチェックすると同時にキーワードを変更した場合、キーワードが削除され、リネームされません!";
$_lang["keywords_no_keywords"] = "現在、登録されたキーワードはありません。";
$_lang["save_all_changes"] = "すべての変更を保存する";
$_lang["new_keyword"] = "キーワードの追加:";
$_lang["confirm_delete_keywords"] = "本当にこれらのキーワードを削除してもよろしいですか?";
$_lang["deselect_keywords"] = "キーワードの選択解除";
$_lang["sort_asc"] = "昇順";
$_lang["sort_desc"] = "降順";
$_lang["sort_tree"] = "ツリーのソート";
$_lang["folder"] = "フォルダ";
$_lang["pagetitle"] = "ドキュメントタイトル";
$_lang["defaulttemplate_title"] = "デフォルトテンプレート";
$_lang["defaulttemplate_message"] = "新しいドキュメントに使用するデフォルトテンプレートを選択してください。ドキュメントエディタで異なるテンプレートを選択することもできます。ここでは、テンプレートの中から事前に選択するテンプレートを設定するのみです。";
$_lang["openurl_message"] = "どのURLを開きますか?";
$_lang["openurl"] = "外部サイトを開く";
$_lang["captcha_words_title"] = "CAPTCHAワード";
$_lang["captcha_words_message"] = "「CAPTCHAコードの使用」を「Yes」にした場合に使用されるCAPTCHAワードリストを入力してください。CAPTCHAワードはカンマで区切ってください。このフィールドには、半角255文字以内入力することができます。";
$_lang["editing_file"] = "ファイルの編集: ";
$_lang["file_not_saved"] = "ファイルを保存できません、ターゲットディレクトリに書き込み権が与えられているか確認してください!";
$_lang["file_saved"] = "ファイルが正常に更新されました!";
$_lang['confirm_delete_file'] = "本当にこのファイルを削除してもよろしいですか?\\n\\n削除することで、あなたのサイトが正常に動作しない場合もあります! 他に影響を及ぼさないことをあなたが理解している場合のみ削除してください。";
$_lang["deleting_file"] = "「 %s 」の削除: ";
$_lang["file_not_deleted"] = "失敗!";
$_lang["file_deleted"] = "成功!";
$_lang["cache_files_deleted"] = "次のファイルが削除されました:";
$_lang['export_site'] = "サイトのエクスポート";
$_lang['export_site_message'] = "この機能を使用して、サイト全体をHTMLファイルにエクスポートすることができます。しかし、下記の多くのEtomiteの機能性を失うことになりますので注意してください:<p /><ul><li>エクスポートファイルのページ閲覧回数は記録されません。</li><li>エクスポートファイルでインタラクティブスニペットは動作しません。</li><li>通常のドキュメントのみエクスポートされ、ウェブリンクはエクスポートされません。</li><li>ドキュメントにリダイレクトヘッダを送信するスニペットが含まれている場合、エクスポートプロセスが失敗する場合があります。</li><li>ドキュメント、スタイルシート、イメージの記述方法により、サイトのデザインが崩れる場合があります。これを直すためには、Etomiteのindex.phpファイルが保存されている同じディレクトリに、エクスポートファイルを保存または移動してください。</li></ul><p />フォームに必要事項を入力して、エクスポートプロセスを開始するために「エクスポートの開始」をクリックしてください。作成されたファイルは、ドキュメントエイリアスをファイル名として、あなたが指定した場所に保存されます。あなたのサイトをエクスポートする場合、Etomite設定で「フレンドリーエイリアス」を「Yes」にすることをお勧めします。あなたのサイトのサイズにより、エクスポートに時間を要する場合もあります。<p /><b>ファイル名が同じ場合、新しいファイルは既存のファイルに上書きされます!</b><p />";
$_lang['export_site_cacheable'] = "未キャッシュファイルを含む:";
$_lang['export_site_prefix'] = "ファイル接頭辞:";
$_lang['export_site_suffix'] = "ファイル接尾辞:";
$_lang['export_site_start'] = "エクスポートの開始";
$_lang['export_site_numberdocs'] = "<b>%s のエクスポート対象ドキュメントが見つかりました...</b><p/>";
$_lang['export_site_exporting_document'] = "エクスポートファイル <b>%s</b>/<b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
$_lang['export_site_success'] = "<span style='color:#009900'>成功!</span>";
$_lang['export_site_failed'] = "<span style='color:#990000'>失敗!</span>";
$_lang['export_site_target_unwritable'] = "ターゲットディレクトリに書き込み権がありません。ディレクトリに書き込み権があるか確認して、もう一度お試しください。";
$_lang['export_site_time'] = "エクスポートが完了しました。エクスポート時間は %s 秒です。";
$_lang['export_site_maxtime'] = "最大エクスポート時間 (秒数):";
$_lang['export_site_maxtime_message'] = "Etomiteがサイトのエクスポートに使用できる秒数を指定してください (PHPの設定を上書きします)。0の入力で時間無制限に設定します。0または非常に大きな数字を設定することで、サーバが正常に動作しない場合もありますのでお勧めしません。";
$_lang['page_data_contentType'] = "コンテンツタイプ";
$_lang['page_data_contentType_help'] = "このドキュメントのコンテンツタイプを選択してください。どのコンテンツタイプか分からない場合、text/htmlのままにしてください。";
$_lang["defaultcache_title"] = "キャッシュデフォルト";
$_lang["defaultcache_message"] = "すべての新しいドキュメントをデフォルトでキャッシュ可能にする場合、「Yes」を選択してください。";
$_lang["defaultpublish_title"] = "公開デフォルト";
$_lang["defaultpublish_message"] = "すべての新しいドキュメントをデフォルトで公開する場合、「Yes」を選択してください。";
$_lang["defaultsearch_title"] = "検索デフォルト";
$_lang["defaultsearch_message"] = "すべての新しいドキュメントをデフォルトで検索可能にする場合、「Yes」を選択してください。";
$_lang["which_editor_title"] = "使用エディタ:";
$_lang["which_editor_message"] = "どのリッチテキストエディタを使用するか選択してください。TinyMCEは快適に動作しますが、Etomiteでは詳細にテストしていません。TinyMCEは、HTMLAreaが提供する機能すべてを満たすわけではありませんが、ドキュメントのマークアップに多くのCSSを使う人には最適です。イメージマネージャ、テーブル操作、その他のHTMLAre設定はTinyMCEに影響しません。同様に、TinyMCEのCSS設定はHTMLAreaに影響しません。";
$_lang["tiny_css_path_title"] = "CSSファイルのパス:";
$_lang["tiny_css_path_message"] = "[TinyMCEのみ] - TinyMCEエディタで使用するCSSファイルのパスを入力してください。パスはルートディレクトリから入力してください。例えば: /assets/site/style.css のように入力します。スタイルシートをエディタにロードしたくない場合、このフィールドを空白のままにしてください。";
$_lang["tiny_css_selectors_title"] = "CSSセレクタ:";
$_lang["tiny_css_selectors_message"] = "[TinyMCEのみ] - エディタで利用可能なセレクタ一覧を入力してください。次のように入力します:<br />'displayName=selectorName;displayName2=selectorName2'<br />例えば、あなたのCSSファイルに<b>.mono</b>と<b>.smallText</b>のセレクタがある場合、次のように追加します:<br />'Monospaced text=mono;Small text=smallText'<br />最後のエントリの後ろには、セミコロンを付けないでください。";
$_lang["manage_modules"] = "モジュール管理";
$_lang["modules_already_installed"] = "インストール済みモジュール";
$_lang["modules_install_new"] = "新しいモジュールのインストール";
$_lang["module_install_info"] = "このモジュールにインストールされているアイテム";
$_lang["type"] = "タイプ";
$_lang["alias"] = "エイリアス";
$_lang["deleted"] = "削除済み";
$_lang["empty_folder"] = "このフォルダは空です。";
$_lang["long_title"] = "長いタイトル"; 
$_lang['document_long_title_help'] = "ドキュメントの長いタイトルを入力してください。これはサーチエンジンに対して効果があります。また、ドキュメントに詳細な情報を記述することができます。"; 
$_lang['search_criteria_longtitle'] = "長いタイトルで検索";
$_lang['search_criteria_longtitle_msg'] = "入力されたテキストですべてのドキュメントの長いタイトルを検索します。";
$_lang['empty_recycle_bin_empty'] = "消去する削除済みドキュメントはありません。";
$_lang['createdon'] = "作成日時";
$_lang['editedon'] = "編集日時";
$_lang['sort_by'] = "並び替え:";
$_lang['sort_dir'] = "並び替え順:";
$_lang['database_tables'] = "データベーステーブル";
$_lang['current_time:'] = "現在の時刻: ";
$_lang['stats_summary_tab'] = "概要";
$_lang['stats_documents_tab'] = "ドキュメント";
$_lang['stats_entry_tab'] = "エントリ";
$_lang['stats_referrers_tab'] = "リファラ";
$_lang['stats_ua_tab'] = "ユーザエージェント";
$_lang['stats_os_tab'] = "オペレーティングシステム";
$_lang['stats_hosts_tab'] = "ホスト";
// Audit trail text
$_lang['audit_trail_subtitle'] = "マネージャーログの表示";
$_lang['audit_trail_heading'] = "検索パラメータ";
$_lang['audit_trail_help'] = "表示するログを選択してください。ログエントリを日付で選択することができますが、あなたが入力する日付は含まれません。01-01-2010のすべてのログエントリを選択するには、「開始日付」を01-01-2010に、「終了日付」を02-01-2010にしてください。通常、メッセージとアクションは同じです。特定のメッセージを検索する場合、アクションで「すべて」を選択してください。";
$_lang['audit_trail_field'] = "フィールド";
$_lang['audit_trail_value'] = "値";
$_lang['audit_trail_user'] = "ユーザ";
$_lang['audit_trail_anyall'] = "すべて";
$_lang['audit_trail_action'] = "アクション";
$_lang['audit_trail_item_id'] = "アイテムID";
$_lang['audit_trail_item_name'] = "アイテム名";
$_lang['audit_trail_msg'] = "メッセージ";
$_lang['audit_trail_date_from'] = "開始日付";
$_lang['audit_trail_date_to'] = "終了日付";
$_lang['audit_trail_dates_sorted'] = "日付の並び替え";
$_lang['audit_trail_sort_asc'] = "古い日付から";
$_lang['audit_trail_sort_desc'] = "新しい日付から";
$_lang['audit_trail_not_set'] = "(未設定)";
$_lang['audit_trail_nr'] = "結果数";
$_lang['audit_trail_results'] = "検索結果";
$_lang['audit_trail_sort_help'] = "<p>カラムヘッダをクリックして、テーブルを並び替えることができます。ログが大きくなり過ぎた場合、ログテーブルのログを空にすることができます。この処理では、過去すべてのログエントリを削除しますが、元に戻すことはできません!</p>"; // modified in 0.6.1-RTMb
$_lang['audit_trail_time'] = "日時";
$_lang['audit_trail_no_search'] = "検索クエリーが入力されていません。";
$_lang['audit_trail_no_results'] = "あなたの検索クエリー対して、空の結果セットが返されました (例 合致するログエントリがありません)。";
$_lang['confirm_move'] = "本当にこのドキュメントを移動してもよろしいですか?\\n移動するには「OK」、中止するには「キャンセル」をクリックしてください。";
$_lang['audit_trail_paging_showing'] = "表示 ";
$_lang['audit_trail_paging_to'] = " - ";
$_lang['audit_trail_paging_next'] = "[次へ]";
$_lang['audit_trail_paging_previous'] = "[前へ]";
$_lang['audit_trail_paging_first'] = "[最初]";
$_lang['audit_trail_paging_last'] = "[最後]";
$_lang['audit_trail_paging_total'] = " 合計";
$_lang['fm_plugin_title'] = "ファイルマネージャ:";
$_lang['fm_plugin_message'] = "[XINHAおよびHTMLArea] - ドキュメントエディタ内のファイルマネージャを有効にしてもよろしいですか? この設定により、ユーザは簡単にファイルをアップロードし、サーバのファイルにリンクすることができます。";
$_lang['fm_plugin_base_url_title'] = "ファイルマネージャアイコンURL:";
$_lang['fm_plugin_base_url_message'] = "通常、この設定は自動的に作成されます。あなたがIISを使用している場合、正しくないアイコンのイメージパスを表示してしまうように、EtomiteはURLを解決できません。この場合、ここにURLを入力してください (マネージャーのフォルダを含むのではなく、あなたがブラウザに入力するURLです)。末尾のスラッシュは含まないでください。";
$_lang['fm_plugin_document_url_title'] = "ファイルマネージャドキュメントURL:";
$_lang['fm_plugin_document_url_message'] = "通常、この設定は自動的に作成されます。あなたがIISを使用している場合、正しくないドキュメントパスを表示してしまうように、EtomiteはURLを解決できません。この場合、ここにドキュメントディレクトリのURLを入力してください (あなたがブラウザに入力するURLです)。";
$_lang['fm_path_title'] = "ファイルマネージャパス:";
$_lang['fm_path_message'] = "通常、この設定は自動的に作成されます。この設定では、ファイルマネージャからファイルがアップロードされる、ディレクトリのサーバパス反映してください。";
$_lang['fm_exclude_title'] = "ファイルマネージャ除外:";
$_lang['fm_exclude_message'] = "ファイルマネージャで除外するフォルダおよびファイルのリストを入力してください。カンマで分離したフォルダおよびファイル名を入力してください。";
$_lang['fm_uploadable_files_title'] = "アップロード可能なファイルタイプ:";
$_lang['fm_uploadable_files_message'] = "あなたがファイルマネージャを使用してアップロードするファイルのリストを入力してください。カンマで分離したファイルタイプの拡張子を入力してください。";
$_lang['xp_plugins_title'] = "XINHAプラグイン:";
$_lang['xp_plugins_message'] = "ドキュメントエディタで有効にしたいプラグインを選択してください。このリストにプラグインを追加または削除したい場合、単純にXINHAプラグインフォルダに追加または削除してください。";
$_lang['xp_stylist_title'] = "スタイリスト:";
$_lang['xp_stylist_message'] = "[XINHAのみ] - ドキュメントエディタでスタイリストプラグインを有効にしますか? この設定では、エディタのコンテンツエリアにCSSファイルを適用します。同様に、ユーザに対してエディタの右側に適用されるクラスを、そのスタイルシートから適用します。";
$_lang['xp_stylist_path_title'] = "Stylist CSSファイルのパス:";
$_lang['xp_stylist_path_message'] = "あなたがXINHAエディタで使用したいスタイリストプラグインCSSファイルの絶対URLを入力してください。パスを入力する最良の方法は、サーバのルートから入力する方法です。 例えば: http://www.myserver.com/assets/site/style.css のように入力します。スタイリストプラグインを有効にするには、スタイルシートを指定してください。";
$_lang['strip_base_href_title'] = "ベースURLを取り除く:";
$_lang['strip_base_href_message'] = "[XINHAおよびHTMLArea] - リンクおよびイメージからベースURLを取り除きたい場合、「Yes」を選択してください。メモ: これは、FirefoxおよびIEでXINHAエディタを使用する場合のみ影響するようです。あなたがファイルマネージャを使用する場合、またはリンクの変更に問題が生じる場合、「No」を選択してください。例えば: 「Yes」にした場合、http://www.myserver.com/link.html は link.html に変更されます。";
$_lang['select_all'] = "すべてを選択する";
$_lang['clear_selected'] = "選択を解除する";
$_lang["which_doc_editor_title"] = "使用するドキュメントエディタ";
$_lang["which_doc_editor_message"] = "ここでは、あなたが使用したいリッチテキストエディタを選択します。HTMLAreaおよびXINHAのみ少しの設定を共有します。それ以外は、それぞれのエディタにおいて設定は排他的です。";
$_lang['im_plugin_message'] = "[XINHAおよびHTMLArea] - ドキュメントエディタでイメージマネージャを有効にしますか? この設定により、ユーザはサーバにイメージをアップロード・編集することができます。";
$_lang['im_plugin_base_dir_message'] = "通常、この設定は自動的に作成されます。あなたがIISを使用している場合、Etomiteはパスを解決できず、イメージマネージャでエラーが発生します。この場合、ここにイメージディレクトリのパスを入力してください (Windwosエクスプローラに表示されるパスです)。"; // changed 0.6 RC2
 $_lang['im_plugin_base_url_message'] = "通常、この設定は自動的に作成されます。あなたがIISを使用している場合、Etomiteはパスを解決できず、イメージマネージャでエラーが発生します。この場合、ここにイメージディレクトリのURLを入力してください (あなたがInternet Explorerに入力するURLです)。"; // changed 0.6 RC2
 $_lang['reset_createdon_date'] = "作成日をリセットする"; // added in 0.6.1-RC2
$_lang['document_reset_createdon_help'] = "このオプションをチェックすることにより、ドキュメント作成日が最終更新日と同じ値にリセットされます。つまり、新しいドキュメントに変更するのと同じです。この機能は、古いドキュメントを新しいドキュメントとして再利用する場合に便利です。"; // added in 0.6.1-RC2
$_lang['sys_info_nothing_found'] = "編集または作成されたドキュメントはありません。";
$_lang['sys_info_bad_number_users'] = "ユーザ名を検索中に不正なユーザ数が返されました!";
$_lang['sys_info_eto_install_info'] = "このページでは、Etomiteインストールに関して一般的な情報を表示します。";
$_lang['sys_info_version_ok'] = " あなたのEtomiteは最新版です。"; // modified in 0.6.1-RC3
$_lang['sys_info_version_update'] = " 最新バージョンの<a href='http://www.etomite.com/downloads.html' target='_blank'>ダウンロード</a>は、"; // modified in 0.6.1-RC3
$_lang['sys_info_version_no_connect'] = " アップデートを確認するため、Etomiteサーバにコンタクトできませんでした。"; // modified in 0.6.1-RC3
$_lang['sys_info_table_instructions'] = "テーブル機能の説明を閲覧する場合、マウスカーソルをテーブル名の上に置いてください (すべてのテーブルに「コメント」があるわけではありません)。";
$_lang['sys_info_table_clear'] = "<b style='color:#990033'>メモ:</b> オーバーヘッドは、MySQLに予約された未使用スペースです。このスペースを開放するには、テーブルオーバーヘッドの数値をクリックしてください。";
$_lang['sys_info_no_active_users'] = "アクティブなユーザが見つかりませんでした。";
$_lang['sys_info_eto_version'] = "バージョン";
$_lang['sys_info_eto_codename'] = "コード名";
$_lang['sys_info_phpinfo'] = "PHP情報";
$_lang['sys_info_view'] = "表示";
$_lang['sys_info_acc_perms'] = "アクセスパーミッション";
$_lang['sys_info_perms_enabled'] = "有効";
$_lang['sys_info_perms_disabled'] = "無効";
$_lang['sys_info_time'] = "サーバタイム";
$_lang['sys_info_local_time'] = "ローカルタイム";
$_lang['sys_info_offset'] = "オフセット";
$_lang['sys_info_offset_text'] = " 時間 (サーバタイム -  ローカルタイムにオフセットが追加されます。)";
$_lang['sys_info_db_name'] = "データベース名";
$_lang['sys_info_db_server'] = "データベースサーバ";
$_lang['sys_info_db_prefix'] = "テーブル接頭辞";
$_lang['sys_info_userid'] = "ユーザ";
$_lang['sys_info_activity_message'] = "このリストでは、最近ユーザが編集したドキュメントを表示します。";
$_lang['sys_info_table_name'] = "テーブル名";
$_lang['sys_info_records'] = "レコード";
$_lang['sys_info_data_size'] = "サイズ";
$_lang['sys_info_overhead'] = "オーバーヘッド (クリア)";
$_lang['sys_info_effective_size'] = "実サイズ";
$_lang['sys_info_index_size'] = "インデックスサイズ";
$_lang['sys_info_total_size'] = "合計";
$_lang['sys_info_base_page_abs'] = "マネージャの絶対パス"; // added in 0.6.1-RC3
$_lang['sys_info_base_page_rel'] = "ウェブルートの相対パス"; // added in 0.6.1-RC3
$_lang['sys_info_base_page_www'] = "マネージャURL"; // added in 0.6.1-RC3
$_lang['document_alias_alert'] = "ドキュメントエイリアスには、文字、数字およびアンダースコア「_」のみ含むことができます。"; // added in 0.6.1-RC2 by Lucky
$_lang['confirm_goto_keywords'] = "キーワード管理ページのドキュメント編集を本当に中断してもよろしいですか? 現在のすべてのドキュメント変更内容が取り消されます!"; // added in 0.6.1 RTM
$_lang['no_preview'] = "未公開コンテンツアイテムはプレビューできません。"; // added in 0.6.1 RTM
$_lang['your_ip_address'] = "あなたのIPアドレスは:"; // added in 0.6.1 RTM

$_lang['xSkin'] = "エディタスキン:"; // added in 0.6.1 RTM
$_lang['xSkin_message'] = "[XINHAのみ] - デフォルト (ブルールック) の代わりにカスタムエディタスキンを選択することができます。この設定はツールバーボタンの概観のみに適用され、エディタのパフォーマンスには影響しません。"; // added in 0.6.1 RTM

$_lang['use_preview_title'] = "プレビューを有効にする:"; // added in 0.6.1 RTMb
$_lang['use_preview_message'] = "ドキュメントデータを閲覧する場合、プレビューパネルでのドキュメントのプレビューを許可しますか? プレビューで問題が発生した場合、どのような理由でもプレビューを無効にしてください。"; // added in 0.6.1 RTMb
$_lang['preview_disabled'] = "現在、ドキュメントプレビューは無効にされています。"; // added in 0.6.1 RTMb
$_lang['audit_trail_empty_logs'] = "ログテーブルを空にする"; // added in 0.6.1 RTMb
$_lang['audit_trail_empty_logs_confirm'] = "本当に管理ユーザのログテーブルを空にしてもよろしいですか? この処理は元に戻せません。"; // added in 0.6.1 RTMb
$_lang['empty_visitor_logs'] = "ビジターログテーブルを空にする"; // added in 0.6.1 RTMb
$_lang['empty_visitor_logs_confirm'] = "本当にビジターログテーブルを空にしてもよろしいですか? この処理は元に戻せません。"; // added in 0.6.1 RTMb
$_lang['generic_delete_confirm'] = "本当にこのレコードを削除してもよろしいですか? この処理は元に戻せません。";
$_lang['require_authenticate'] = "認証?";
$_lang['require_authenticate_help'] = "このオプションをチェックした場合、ユーザがこのドキュメントにアクセスする前に認証が必要となります。Etomite設定で「アクセスパーミッションの使用」が有効にされている場合、高度なドキュメントグループ認証が実行されます。そうでない場合、認証には有効なログインセッションのみ使用されます。";
$_lang["uvperms_title"] = "ビジターパーミッションを使用する";
$_lang["uvperms_message"] = "このオプションでは、どのページにサイトビジターが閲覧できるのか、管理ユーザのアクセスパーミッションをすべてのユーザに拡張します。あなたがユーザグループおよびドキュメントグループパーミッションを熟知している場合のみ有効にしてください。";
$_lang["access_denied_title"] = "アクセス拒否メッセージ:";
$_lang["access_denied_message"] = "アクセス保護エリアにアクセスを試みられた場合、システムデフォルトメッセージの代わりに表示するカスタムメッセージをここに入力することができます。ここでは、HTMLおよびJavaスクリプトを使用することができます。<br />Javaスクリプトを使用したリダイレクトです (フレンドリーエイリアスが有効にされた場合):<br />&lt;script type=\"text/javascript\"&gt;location.href='access_denied'&lt;/script&gt;";

/* END: added in 0.6.1 Final */

/* START: added in 0.6.1.4 */
$_lang['showinmenu'] = "メニューに表示する:";
$_lang['showinmenu_help'] = "このドキュメントがメニューおよび他のドキュメント一覧に表示されるかどうか選択することができます。この設定で古いスニペットは無視されますので注意してください。";
$_lang['tree_drag_parent'] = "親を変更するには、ここにドラッグしてください。";
$_lang['tree_drag_sort'] = "順番を変更するには、ここにドラッグしてください。";
$_lang['tree_drop_recycle'] = "ドキュメントを削除するには、ドロップしてください。";
$_lang['tree_refresh_needed'] = "他のユーザによってメニューツリーが編集されました。あなたの変更を再度適用してください。";
$_lang['tree_refresh_save_first'] = "他のユーザによってメニューツリーが編集およびリフレッシュされました。あなたのドキュメントを保存してください。";
$_lang['tree_save_changes'] = "現在、あなたはドキュメントを編集しています。続ける場合、変更内容が取り消されます。続けてもよろしいですか?";
$_lang['alias_exists'] = "エイリアスがすでに登録されています!";
$_lang['alias_exists_alert'] = "すでに登録されていないエイリアスを使用してください。";
$_lang['create_new_dir'] = "ディレクトリの作成:";
$_lang['create_new_dir_note'] = "<b>メモ:</b> 新しいディレクトリは、編集および削除することはできません。また、r+wパーミッションが設定されます。";
$_lang['create_new_dir_button'] = "作成"; 

/* END: added in 0.6.1.4 */

/* START: added in [v1.0] */
$_lang['page_data_createdon_help'] = "この日付は、ドキュメントの作成日時より自動的に計算されます。カレンダーアイコンをクリックすることで、作成日時を手動で選択することができます。カレンダーアイコン隣のアイコンをクリックすることで、ドキュメント保存時、自動的に日付が計算されます。";
$_lang["defaultsyncsitecheck_title"] = "キャッシュデフォルトのクリア:";
$_lang["defaultsyncsitecheck_message"] = "「Yes」を選択した場合、保存時にキャッシュからドキュメントがクリアされます。「No」を選択した場合、「キャッシュのクリア」処理が実行されるまで、古いバージョンはキャッシュに保持されます。";
$_lang["defaultshowinmenu_title"] = "デフォルトでメニューに表示する:";
$_lang["defaultshowinmenu_message"] = "「Yes」を選択した場合、ドキュメントはデフォルトでメニューに表示されます。「No」を選択した場合、ドキュメントはデフォルトでメニューに表示されません。";
$_lang["maxuploadsize_title"] = "最大アップロードサイズ:";
$_lang["maxuploadsize_message"] = "ここでは、ファイルマネージャでの最大アップロードサイズを指定することができます。この設定は、PHPのシステム設定 <b>[".@ini_get("upload_max_filesize")."]</b> をオーバーライドしません。空白にした場合、現在のPHPの制限が使用されます。例: '100K', '8M', '1048576'";
$_lang["inlineviewable_files_title"] = "インラインで閲覧可能なファイルタイプ:";
$_lang["inlineviewable_files_message"] = "ここで入力したファイルタイプ (テキスト) は、ファイルマネージャのプレビューパネルで閲覧することができます。";
$_lang["viewable_files_title"] = "閲覧可能なファイルタイプ:";
$_lang["viewable_files_message"] = "ここで入力したファイルタイプ (イメージ) は、ファイルマネージャのプレビューパネルで閲覧することができます。";
$_lang["editable_files_title"] = "編集可能なファイルタイプ:";
$_lang["editable_files_message"] = "ここで入力したファイルタイプは、ファイルマネージャの編集パネルで編集することができます。";
$_lang["exclude_paths_title"] = "除外パス";
$_lang["exclude_paths_message"] = "ここで指定したパスは、ファイルマネージャで閲覧することができません。";
$_lang["showinmenu"] = "メニューに表示する";
$_lang["confirm_showinmenu"] = "本当にこのドキュメントをメニューに表示してもよろしいですか?\\n\\n注意: この機能の有効性は、メニュースクリプトの使用に依存します。";
$_lang["hideinmenu"] = "メニューから隠す";
$_lang["confirm_hideinmenu"] = "本当にこのドキュメントをメニューから隠してもよろしいですか?\\n\\n注意: この機能の有効性は、メニュースクリプトの使用に依存します。";
$_lang['role_chunk_management'] = "チャンク管理";
$_lang['role_create_chunk'] = "チャンクの作成";
$_lang['role_edit_chunk'] = "チャンクの編集";
$_lang['role_save_chunk'] = "チャンクの保存";
$_lang['role_delete_chunk'] = "チャンクの削除";
$_lang["mgr_logging_title"] = "ログの使用:";
$_lang["mgr_logging_message"] = "この設定では、ユーザロギングを (追跡記録) を有効にします。この機能を無効にすることにより、データベース保存領域を減らし、全般的なパフォーマンスを少しだけ上げることができます。";
$_lang["mgr_logging_disabled"] = "Etomite Managerのユーザロギング (追跡記録) は無効にされています。";
$_lang["date_format"] = "日付表示フォーマット:";
$_lang["date_format_message"] = "Managerの日付表示に使用される日付フォーマットを選択してください。あなたは<b>\$etomite->config['date_format']</b>を使用して、この設定をスニペットでも使用することができます。";
$_lang["time_format"] = "時刻表示フォーマット:";
$_lang["time_format_message"] = "Managerの時間表示に使用される時間フォーマットを選択してください。あなたは<b>\$etomite->config['time_format']</b>を使用して、この設定をスニペットでも使用することができます。";
$_lang["max_attempts_title"] = "最大ログイン回数:";
$_lang["max_attempts_message"] = "この設定では、ユーザアカウントがブロックされるまで何回連続でログインを失敗することができるか指定します。ブロックされた場合、管理者のみユーザアカウントのブロックを解除することができます。";
$_lang["xLang"] = "Xinha言語:";
$_lang["xLang_message"] = "代わりのXinha言語ファイルをインストールした場合、あなたはどの言語をXinhaエディタが使用するか選択することができます。";
$_lang["allow_embedded_php_title"] = "埋め込みPHPを許可する:";
$_lang["allow_embedded_php_message"] = "この設定を「Yes」にした場合、さらなる開発柔軟性のため、あなたはテンプレートおよびチャンクにPHPコードを埋め込むことができます。セキュリティの理由から、この機能が必要ではない場合、またはあなたがこの意味を理解できない場合、「No」のままにしてください。";
$_lang["useNotice_title"] = "リンクバックの表示:";
$_lang["useNotice_message"] = "この設定では、デフォルトの<b>Powered By Etomite</b>リンクバックを表示するかどうか決定します。このリンクは、<b>#etoNotice</b>CSS要素を使用して設置することもできます。Etomiteプロジェクトに対する何らかの形の謝辞掲載をお願い致しておりますが、いくつかのサイトではデフォルトのリンクバックが全体のデザインに適していないことも私たちは認識しております。あなたがリンクバック謝辞を提供したくない場合、Etomiteプロジェクトへの寄付をお考えください。";
$_lang["dumpSQL_title"] = "デバッグSQL:";
$_lang["dumpSQL_message"] = "この設定は、開発の場合のみ有効にしてください。実運用サイトでは、無効のままにしてください。有効にした場合、すべてのページにSQLクエリー情報が表示されます。この機能が必要ではない場合、またはあなたがこの意味を理解できない場合、「No」のままにしてください。";
$_lang["dumpSnippets_title"] = "デバッグスニペット:";
$_lang["dumpSnippets_message"] = "この設定は、開発の場合のみ有効にしてください。実運用サイトでは、無効のままにしてください。有効にした場合、すべてのページにスニペット情報が表示されます。この機能が必要ではない場合、またはあなたがこの意味を理解できない場合、「No」のままにしてください。";
/* END: added in [v1.0] */
?>